/*
 * Decompiled with CFR 0.152.
 */
package noppes.npcs.client.gui.player.companion;

import javax.annotation.Nonnull;
import net.minecraft.block.Block;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.math.MathHelper;
import noppes.npcs.CustomNpcs;
import noppes.npcs.NoppesStringUtils;
import noppes.npcs.NoppesUtilPlayer;
import noppes.npcs.client.gui.util.GuiContainerNPCInterface;
import noppes.npcs.client.gui.util.GuiMenuTopIconButton;
import noppes.npcs.client.gui.util.GuiNPCInterface;
import noppes.npcs.client.gui.util.GuiNpcLabel;
import noppes.npcs.client.gui.util.IGuiData;
import noppes.npcs.constants.EnumCompanionJobs;
import noppes.npcs.constants.EnumCompanionTalent;
import noppes.npcs.constants.EnumGuiType;
import noppes.npcs.constants.EnumPlayerPacket;
import noppes.npcs.entity.EntityNPCInterface;
import noppes.npcs.roles.RoleCompanion;

public class GuiNpcCompanionStats
extends GuiNPCInterface
implements IGuiData {
    private boolean isEating = false;
    private final RoleCompanion role;

    public static void addTopMenu(RoleCompanion role, GuiScreen screen, int active) {
        GuiMenuTopIconButton button;
        if (screen instanceof GuiNPCInterface) {
            GuiNPCInterface gui = (GuiNPCInterface)screen;
            button = new GuiMenuTopIconButton(1, gui.guiLeft + 4, gui.guiTop - 27, "menu.stats", new ItemStack(Items.field_151122_aG));
            gui.addTopButton(button);
            button = new GuiMenuTopIconButton(2, button, "companion.talent", new ItemStack(Items.field_151156_bN));
            gui.addTopButton(button);
            if (role.hasInv()) {
                button = new GuiMenuTopIconButton(3, button, "inv.inventory", new ItemStack((Block)Blocks.field_150486_ae));
                gui.addTopButton(button);
            }
            if (role.job != EnumCompanionJobs.NONE) {
                gui.addTopButton(new GuiMenuTopIconButton(4, button, "job.name", new ItemStack(Items.field_151172_bF)));
            }
            gui.getTopButton(active).setActive(true);
        }
        if (screen instanceof GuiContainerNPCInterface) {
            GuiContainerNPCInterface gui2 = (GuiContainerNPCInterface)screen;
            button = new GuiMenuTopIconButton(1, gui2.field_147003_i + 4, gui2.field_147009_r - 27, "menu.stats", new ItemStack(Items.field_151122_aG));
            gui2.addTopButton(button);
            button = new GuiMenuTopIconButton(2, button, "companion.talent", new ItemStack(Items.field_151156_bN));
            gui2.addTopButton(button);
            if (role.hasInv()) {
                button = new GuiMenuTopIconButton(3, button, "inv.inventory", new ItemStack((Block)Blocks.field_150486_ae));
                gui2.addTopButton(button);
            }
            if (role.job != EnumCompanionJobs.NONE) {
                gui2.addTopButton(new GuiMenuTopIconButton(4, button, "job.name", new ItemStack(Items.field_151172_bF)));
            }
            gui2.getTopButton(active).setActive(true);
        }
    }

    public GuiNpcCompanionStats(EntityNPCInterface npc) {
        super(npc);
        this.role = (RoleCompanion)npc.advanced.roleInterface;
        this.closeOnEsc = true;
        this.setBackground("companion.png");
        this.xSize = 171;
        this.ySize = 166;
        NoppesUtilPlayer.sendData(EnumPlayerPacket.RoleGet, new Object[0]);
    }

    @Override
    public void func_146284_a(@Nonnull GuiButton guibutton) {
        super.func_146284_a(guibutton);
        int id = guibutton.field_146127_k;
        if (id == 2) {
            CustomNpcs.proxy.openGui(this.npc, EnumGuiType.CompanionTalent);
        }
        if (id == 3) {
            NoppesUtilPlayer.sendData(EnumPlayerPacket.CompanionOpenInv, new Object[0]);
        }
    }

    public void drawHealth(int y) {
        int x2;
        int j;
        this.field_146297_k.func_110434_K().func_110577_a(field_110324_m);
        int max = this.role.getTotalArmorValue();
        if (this.role.talents.containsKey((Object)EnumCompanionTalent.ARMOR) || max > 0) {
            for (int i = 0; i < 10; ++i) {
                int x = this.guiLeft + 66 + i * 10;
                if (i * 2 + 1 < max) {
                    this.func_73729_b(x, y, 34, 9, 9, 9);
                }
                if (i * 2 + 1 == max) {
                    this.func_73729_b(x, y, 25, 9, 9, 9);
                }
                if (i * 2 + 1 <= max) continue;
                this.func_73729_b(x, y, 16, 9, 9, 9);
            }
            y += 10;
        }
        max = MathHelper.func_76123_f((float)this.npc.func_110138_aP());
        int k = (int)this.npc.func_110143_aJ();
        if (max > 40) {
            float scale = (float)max / 40.0f;
            k /= (int)scale;
            max = 40;
        }
        for (j = 0; j < max; ++j) {
            x2 = this.guiLeft + 66 + j % 20 * 5;
            int offset = j / 20 * 10;
            this.func_73729_b(x2, y + offset, 52 + j % 2 * 5, 9, j % 2 == 1 ? 4 : 5, 9);
            if (k <= j) continue;
            this.func_73729_b(x2, y + offset, 52 + j % 2 * 5, 0, j % 2 == 1 ? 4 : 5, 9);
        }
        k = this.role.foodstats.getFoodLevel();
        y += 10;
        if (max > 20) {
            y += 10;
        }
        for (j = 0; j < 20; ++j) {
            x2 = this.guiLeft + 66 + j % 20 * 5;
            this.func_73729_b(x2, y, 16 + j % 2 * 5, 27, j % 2 == 1 ? 4 : 5, 9);
            if (k <= j) continue;
            this.func_73729_b(x2, y, 52 + j % 2 * 5, 27, j % 2 == 1 ? 4 : 5, 9);
        }
    }

    @Override
    public void func_73863_a(int i, int j, float f) {
        super.func_73863_a(i, j, f);
        if (this.isEating && !this.role.isEating()) {
            NoppesUtilPlayer.sendData(EnumPlayerPacket.RoleGet, new Object[0]);
        }
        this.isEating = this.role.isEating();
        super.drawNpc(34, 150);
        this.drawHealth(this.guiTop + 88);
    }

    @Override
    public void func_73866_w_() {
        super.func_73866_w_();
        int y = this.guiTop + 10;
        this.addLabel(new GuiNpcLabel(0, NoppesStringUtils.translate("gui.name", ": ", this.npc.display.getName()), this.guiLeft + 4, y));
        int id = 1;
        String translate = NoppesStringUtils.translate("companion.owner", ": ", this.role.ownerName);
        int x = this.guiLeft + 4;
        this.addLabel(new GuiNpcLabel(id, translate, x, y += 12));
        int id2 = 2;
        String translate2 = NoppesStringUtils.translate("companion.age", ": ", this.role.ticksActive / 18000L + " (", this.role.stage.name, ")");
        int x2 = this.guiLeft + 4;
        this.addLabel(new GuiNpcLabel(id2, translate2, x2, y += 12));
        int id3 = 3;
        String translate3 = NoppesStringUtils.translate("companion.strength", ": ", this.npc.stats.melee.getStrength());
        int x3 = this.guiLeft + 4;
        this.addLabel(new GuiNpcLabel(id3, translate3, x3, y += 12));
        int id4 = 4;
        String translate4 = NoppesStringUtils.translate("companion.level", ": ", this.role.getTotalLevel());
        int x4 = this.guiLeft + 4;
        this.addLabel(new GuiNpcLabel(id4, translate4, x4, y += 12));
        int id5 = 5;
        String translate5 = NoppesStringUtils.translate("job.name", ": ", "gui.none");
        int x5 = this.guiLeft + 4;
        this.addLabel(new GuiNpcLabel(id5, translate5, x5, y += 12));
        GuiNpcCompanionStats.addTopMenu(this.role, this, 1);
    }

    @Override
    public void setGuiData(NBTTagCompound compound) {
        this.role.load(compound);
    }
}

